  //
 //  Written by Morgion
//
using System;
using System.IO;
using Server.Gumps;
using System.Collections;
using Server;
using Server.Items;
using Server.Network;
using Server.Prompts;
using System.Collections.Generic;
using Server.Misc;
using Server.Targeting;

namespace Server.Gumps
{
	public class MonsterContractBookGump : Gump
	{
		private MonsterContractBook m_Book;

		public MonsterContractBook Book{ get{ return m_Book; } }

		public string GetName( string name )
		{
			if ( name == null || (name = name.Trim()).Length <= 0 )
				return "(indescript)";

			return name;
		}

		public MonsterContractBookGump( Mobile from, MonsterContractBook book ) : base( 150, 200 )
		{
			m_Book = book;

        this.Closable=true;
        this.Disposable=true;
        this.Dragable=true;
        this.Resizable=false;
        this.AddPage(0);
        this.AddBackground(0, 0, 271, 365, 3500);
        this.AddLabel(55, 9, 76, @"Kniha na lovecke zakazky");
        
        if ( m_Book.Entries.Count > 0 )
        {
            int y = 35;
            for ( int i = 0; i < m_Book.Entries.Count; ++i )
            {
               MonsterContractBookEntry e = (MonsterContractBookEntry)m_Book.Entries[i];
               int btn = (i * 2) + 1;
               
               this.AddLabel(35, y-2, 0, GetName( e.Monster ) + " " + String.Format("{0}/{1}",e.AmountKilled ,e.AmountToKill) );
               if ( e.AmountKilled < e.AmountToKill )
                  this.AddButton(14, y, 2117, 2118, btn + 1, GumpButtonType.Reply, 0);
                  
               this.AddButton(242, y, 4034, 4034, btn, GumpButtonType.Reply, 0);
               y += 20;
            }
        
        }
		}

		public override void OnResponse( NetState state, RelayInfo info )
		{
			Mobile from = state.Mobile;

			if ( m_Book.Deleted || !from.InRange( m_Book.GetWorldLocation(), 1 ) || !Multis.DesignContext.Check( from ) )
				return;

			int buttonID = info.ButtonID;

			int index = (buttonID / 2);
			int drp = buttonID % 2; // 1 = drop 0 = claim

			if ( index >= 0 && index < m_Book.Entries.Count && drp == 1 )
			{
				MonsterContractBookEntry e = (MonsterContractBookEntry)m_Book.Entries[index];

				if ( m_Book.CheckAccess( from ) )
				{
					m_Book.DropContract( from, e, index );
					from.CloseGump( typeof( MonsterContractBookGump ) );
					from.SendGump( new MonsterContractBookGump( from, m_Book ) );
				}
				else
				{
					from.SendLocalizedMessage( 502413 ); // That cannot be done while the book is locked down.
				}
			}
			else	if (index >= 1 && index < m_Book.Entries.Count +1 && drp == 0)
			{
				index = index - 1;
            MonsterContractBookEntry e = (MonsterContractBookEntry)m_Book.Entries[index];
				if ( m_Book.CheckAccess( from ) )
				{
               from.SendMessage("Vyber mrtvolu kterou chces pridat.");
				   from.Target = new MonsterCorpseTarget( e, m_Book );	
					from.CloseGump( typeof( MonsterContractBookGump ) );
					from.SendGump( new MonsterContractBookGump( from, m_Book ) );
				}
				else
				{
					from.SendLocalizedMessage( 502413 ); // That cannot be done while the book is locked down.
				}
			}
		}
	}
	
	public class MonsterCorpseTarget : Target
	{
		private MonsterContractBookEntry MCparent;
		private MonsterContractBook m_Book;
		
		public MonsterCorpseTarget( MonsterContractBookEntry parentMC, MonsterContractBook book ) : base( -1, true, TargetFlags.None )
		{
			MCparent = parentMC;
			m_Book = book;
		}
		
		protected override void OnTarget( Mobile from, object o )
		{
			if ( o is Corpse )
			{
				Corpse MCcorpse = (Corpse)o;
				
				if ( MCparent == null || m_Book == null || m_Book.Deleted || MCcorpse == null || ((Item)MCcorpse).Deleted )
				{
					from.SendMessage("Kontrakt nenalezen!");
					return;
				}
				else if ( MCcorpse.Channeled )
				{
					from.SendMessage("Zneuctena mrtvola nemuze byt pridana do zakazky!");
					return;
				}
				else if ( MCparent.AmountKilled >= MCparent.AmountToKill )
				{
					from.SendMessage("Kontrakt je splnen!");
					return;
				}
				if ( MCcorpse.CanLoot( from ) )
				{
					string m_type = "a " + MCparent.Monster;
					m_type = m_type.ToLower();
					string m_type2 = "an " + MCparent.Monster;
					m_type2 = m_type2.ToLower();
					
					if ( MCcorpse.Owner == null )
               {
						from.SendMessage("Tuto mrtvolu nelze pridat do zakazky!");
						return;
               }
                  
					string m_corpse = MCcorpse.Owner.Name;
					m_corpse = m_corpse.ToLower();
					
					if ( m_type == m_corpse || m_type2 == m_corpse )
					{
						MCparent.AmountKilled += 1;
						MCcorpse.Delete();
						from.CloseGump( typeof( MonsterContractBookGump ) );
			         from.SendGump( new MonsterContractBookGump( from, m_Book ) );
					}
					else
						from.SendMessage("Nespravny typ mrtvoly!");
				}
				else
					from.SendMessage("Nemuzes sebrat praci nekoho jineho pro sebe!");
			}
			else
				from.SendMessage("Toto neni mrtvola");
		}
	}
}